/*
 * Tektronix 4014 sketcher.
 *
 * Jim Rees, University of Michigan, March 1999
 */

#pragma pack(2)

#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

#include "teksketch.h"

#define p160toTekX(x) ((int)((x) * 4096L / 160L))
#define p160toTekY(x) ((int)(3072L - (x) * 3072L / 160L))

static Boolean teksketch(EventPtr event);

DWord
PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
    int err;

    if (cmd == sysAppLaunchCmdNormalLaunch) {
	err = StartApplication();
	if (err)
	    return err;
	EventLoop();
	StopApplication();
	return 0;
    } else
	return sysErrParamErr;
}

StartApplication()
{
    tiosetup(0);
    teksetbuf(1);
    FrmGotoForm(formID_teksketch);
    return 0;
}

StopApplication()
{
    tioclose();
    return 0;
}

EventLoop()
{
    short err;
    int formID;
    FormPtr form;
    EventType event;

    do {
	EvtGetEvent(&event, 200);

	if (SysHandleEvent(&event))
	    continue;
	if (MenuHandleEvent((void *)0, &event, &err))
	    continue;

	if (event.eType == frmLoadEvent) {
	    formID = event.data.frmLoad.formID;
	    form = FrmInitForm(formID);
	    FrmSetActiveForm(form);
	    switch (formID) {
	    case formID_teksketch:
		FrmSetEventHandler(form, (FormEventHandlerPtr) teksketch);
		break;
	    }
	}
	FrmDispatchEvent(&event);
    } while (event.eType != appStopEvent);
}

static Boolean
teksketch(EventPtr event)
{
    FormPtr form = FrmGetActiveForm();
    Word field;
    int handled = 0;
    static short x0, y0;
    char *cp, buf[4];

    switch (event->eType) {
    case frmOpenEvent:
	FrmDrawForm(form);
	handled = 1;
	break;

    case penDownEvent:
	move(p160toTekX(event->screenX), p160toTekY(event->screenY));
	handled = 1;
	break;

    case penMoveEvent:
	draw(p160toTekX(event->screenX), p160toTekY(event->screenY));
	handled = 1;
	break;

    case penUpEvent:
	x0 = p160toTekX(event->screenX);
	y0 = p160toTekY(event->screenY);
	handled = 1;
	break;

    case keyDownEvent:
	if (event->data.keyDown.chr == '\n') {
	    y0 -= 88;
	    move(x0, y0);
	} else {
	    cp = buf;
	    *cp++ = event->data.keyDown.chr;
	    *cp = '\0';
	    puttext(buf);
	}
	tflush();
	handled = 1;
	break;

    case menuEvent:
	field = FrmGetFocus(form);
	switch (event->data.menu.itemID) {
	case menuitemID_solid:
	    setlinepat("solid");
	    break;
	case menuitemID_dashed:
	    setlinepat("longdashed");
	    break;
	case menuitemID_dotted:
	    setlinepat("dotted");
	    break;
	case menuitemID_erase:
	    clear();
	    break;
	case menuitemID_about:
	    FrmAlert(alertID_about);
	    break;
	}
	handled = 1;
	break;

    }
    return handled;
}

/*
copyright 1999
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works
and redistribute this software and such derivative works
for any purpose, so long as the name of the university of
michigan is not used in any advertising or publicity
pertaining to the use or distribution of this software
without specific, written prior authorization.  if the
above copyright notice or any other identification of the
university of michigan is included in any copy of any
portion of this software, then the disclaimer below must
also be included.

this software is provided as is, without representation
from the university of michigan as to its fitness for any
purpose, and without warranty by the university of
michigan of any kind, either express or implied, including
without limitation the implied warranties of
merchantability and fitness for a particular purpose. the
regents of the university of michigan shall not be liable
for any damages, including special, indirect, incidental, or
consequential damages, with respect to any claim arising
out of or in connection with the use of the software, even
if it has been or is hereafter advised of the possibility of
such damages.
*/
