
__version__ = "0.2"

__all__ = ["BaseHTTPRequestHandler"]

import sys
import time
import mimetools
import hweb_config
import hweb_lib
import string
import shelve

DEFAULT_ERROR_MESSAGE = """\
<head>
<title>Error response</title>
</head>
<body>
<h1>Error response</h1>
<p>Error code %(code)d.
<p>Message: %(message)s.
<p>Error code explanation: %(code)s = %(explain)s.
</body>
"""

class HD_BaseHTTPRequestHandler:
    def __init__(self,ip,port,cache):
	self.rfile = sys.stdin
	self.wfile = sys.stdout
	self.ip = ip
	self.port = port
   	sys_version = "" 
    	server_version = "" + __version__
	self.handle()

    def parse_request(self):
        """Parse a request (internal).
        """
        self.request_version = version = "HTTP/1.1" # Default
        requestline = self.raw_requestline
        if requestline[-2:] == '\r\n':
            requestline = requestline[:-2]
        elif requestline[-1:] == '\n':
            requestline = requestline[:-1]
        self.requestline = requestline
        words = string.splitfields(requestline)
        if len(words) == 3:
            [command, path, version] = words
            self.command, self.path, self.request_version = command, path, version
            if version[:5] != 'HTTP/':
                self.send_error_hw(400, 'a', "Bad Request" )
                return 0
        elif len(words) == 2:
            [command, path] = words
            if command != 'GET':
                self.send_error_hw(400,'b',
                                "Bad HTTP/0.9 request (%s)" % `command`)
		""" We send back a decent apache page but windows doesn't appear to honor the spec and actually returns 
		    404 or other pages instead
		"""
                return 0
        else:
            self.send_error_hw(400,'c', "Bad request syntax (%s)" % `requestline`)
	    """ I think I will need to see this error out to see the type or response pages that need to be sent back
	    """
            return 0
        self.command, self.path, self.request_version = command, path, version
        self.headers = self.MessageClass(self.rfile, 0)
	if version == 'HTTP/1.1':
		if not self.headers.has_key('host'):
                	self.send_error_hw(400,'d', "Bad Request")
 			return 0
        return 1

    def handle(self):
        """Handle a single HTTP request.

        You normally don't need to override this method; see the class
        __doc__ string for information on how to handle specific HTTP
        commands such as GET and POST.

        """

        self.raw_requestline = self.rfile.readline()
        if not self.parse_request(): # An error code has been sent, just exit
	    print "Error in parse req"
            return
        mname = 'do_' + self.command
        if not hasattr(self, mname):
            self.send_error_method()
            return
        method = getattr(self, mname)
        method()

    def send_error_hw(self, code, type, message=None):
	"""This function returns server specific error pages for apache
	   and win platforms
	"""	
	persistent = shelve.open(cache)
	#[host, port] = self.client_address
	host = self.ip 
	port = self.port	
	if hweb_config.persist == 1:
		try:
			family=persistent[host][2]
			self.server_version=persistent[host][0]
		except KeyError:
			[result,family,resp_code]=hweb_lib.get_match(self.path)
			self.server_version=result
	else:
		[result,family,resp_code]=hweb_lib.get_match(self.path)
		self.server_version=result

	if family =='random_unix':
		page = "html/error-pages/apache_" + str(code) + type + ".html"
		in_file = open(page, 'r')
		tmp = in_file.read()
		html = tmp % (self.server_version)
		in_file.close() 

	elif family == 'random_win':
		page = "html/error-pages/win_" + str(code) + type + ".html"
		in_file = open(page, 'r')
		html = in_file.read()
		in_file.close() 
	else: 
		"""I really hope we have a server version so we are going to fake it"
		"""
		if self.server_version[:5] == 'Micro':
			page = "html/error-pages/win_" + str(code) + type + ".html"
			in_file = open(page, 'r')
			html = in_file.read()
			in_file.close() 
		else:
			page = "html/error-pages/apache_" + str(code) + type + ".html"
			in_file = open(page, 'r')
			tmp = in_file.read()
			html = tmp % (self.server_version)
			in_file.close() 
				
	c_len = len(html)
        if self.request_version != 'HTTP/0.9':
            self.wfile.write("HTTP/1.1 %s %s\r\n" %
        				(code, message))
       	self.send_header("Content-Type", "text/html")
       	self.send_header("Content-Length", c_len)
       	self.end_headers()
       	self.wfile.write(html)
	persistent.close()


    def send_error_method(self):
	"""This function returns server specific method error pages for apache
	   and win platforms 
	"""	
	persistent = shelve.open(cache)
	[host, port] = self.client_address
	if hweb_config.persist == 1:
		try:
			family=persistent[host][2]
			self.server_version=persistent[host][0]
		except KeyError:
			[result,family,resp_code]=hweb_lib.get_match(self.path)
			self.server_version=result
	else:
		[result,family,resp_code]=hweb_lib.get_match(self.path)
		self.server_version=result

	if family =='random_unix':
		page = "html/error-pages/apache_405.html"
		in_file = open(page, 'r')
		tmp = in_file.read()
		html = tmp % (self.command, self.path, self.server_version)
		in_file.close() 
		code = '405'
		message = "Method Not Allowed" 

	elif family == 'random_win':
		page = "html/error-pages/win_501.html"
		in_file = open(page, 'r')
		html = in_file.read()
		in_file.close() 
		code = "501"
		message = "Not Supported"
	else: 
		"""I really hope we have a server version so we are going to fake it"
		"""
		if self.server_version[:5] == 'Micro':
			page = "html/error-pages/win_" + str(code) + type + ".html"
			in_file = open(page, 'r')
			html = in_file.read()
			in_file.close() 
			code = "501"
			message = "Not Supported"
		else:
			page = "html/error-pages/apache_405.html"
			in_file = open(page, 'r')
			tmp = in_file.read()
			html = tmp % (self.command, self.path, self.server_version)
			in_file.close() 
			code = '405'
			message = "Method Not Allowed" 
	c_len = len(html)
        if self.request_version != 'HTTP/0.9':
            self.wfile.write("HTTP/1.1 %s %s\r\n" %
        				(code, message))
       	self.send_header("Content-Type", "text/html")
       	self.send_header("Content-Length", c_len)
       	self.end_headers()
       	self.wfile.write(html)
	persistent.close()


    def send_response(self, code, family, message=None):
        """Send the response header and log the response code.

        Also send two standard headers with the server software
        version and the current date.

        """
        #self.log_request(code)
        if message is None:
	    if family == 'random_win':
            	if self.responses_win.has_key(code):
                	message = self.responses_win[code][0]
            	else:
                	message = ''
	    else:
            	if self.responses.has_key(code):
                	message = self.responses[code][0]
            	else:
                	message = ''
        if self.request_version != 'HTTP/0.9':
            self.wfile.write("%s %s %s\r\n" %
                             (self.protocol_version, str(code), message))
        self.send_header('Server', self.version_string())
        self.send_header('Date', self.date_time_string())

    def send_header(self, keyword, value):
        """Send a MIME header."""
        if self.request_version != 'HTTP/0.9':
            self.wfile.write("%s: %s\r\n" % (keyword, value))

    def end_headers(self):
        """Send the blank line ending the MIME headers."""
        if self.request_version != 'HTTP/0.9':
            self.wfile.write("\r\n")

    def log_request(self, code='-', size='-'):
        """Log an accepted request.

        This is called by send_reponse().

        """

        self.log_message('"%s" %s %s',
                         self.requestline, str(code), str(size))

    def log_error(self, *args):
        """Log an error.

        This is called when a request cannot be fulfilled.  By
        default it passes the message on to log_message().

        Arguments are the same as for log_message().

        XXX This should go to the separate error log.

        """

        apply(self.log_message, args)

    def log_message(self, format, *args):
        """Log an arbitrary message.

        This is used by all other logging functions.  Override
        it if you have specific logging wishes.

        The first argument, FORMAT, is a format string for the
        message to be logged.  If the format string contains
        any % escapes requiring parameters, they should be
        specified as subsequent arguments (it's just like
        printf!).

        The client host and current date/time are prefixed to
        every message.

        """

        sys.stderr.write("%s - - [%s] %s\n" %
                         (self.address_string(),
                          self.log_date_time_string(),
                          format%args))

    def version_string(self):
        """Return the server software version string."""
        return self.server_version + ' ' + self.sys_version

    def date_time_string(self):
        """Return the current date and time formatted for a message header."""
        now = time.time()
        year, month, day, hh, mm, ss, wd, y, z = time.gmtime(now)
        s = "%s, %02d %3s %4d %02d:%02d:%02d GMT" % (
                self.weekdayname[wd],
                day, self.monthname[month], year,
                hh, mm, ss)
        return s

    def log_date_time_string(self):
        """Return the current time formatted for logging."""
        now = time.time()
        year, month, day, hh, mm, ss, x, y, z = time.localtime(now)
        s = "%02d/%3s/%04d %02d:%02d:%02d" % (
                day, self.monthname[month], year, hh, mm, ss)
        return s

    weekdayname = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']

    monthname = [None,
                 'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
                 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']

    def address_string(self):
        """Return the client address formatted for logging.

        This version looks up the full hostname using gethostbyaddr(),
        and tries to find a name that contains at least one dot.

        """
	

        (host, port) = self.client_address
        try:
            name, names, addresses = socket.gethostbyaddr(host)
        except socket.error, msg:
            return host
        names.insert(0, name)
        for name in names:
            if '.' in name: return name
        return names[0]
    # Essentially static class variables

    # The version of the HTTP protocol we support.
    # Don't override unless you know what you're doing (hint: incoming
    # requests are required to have exactly this version string).
    protocol_version = "HTTP/1.0"

    # The Message-like class used to parse headers
    MessageClass = mimetools.Message

    # Table mapping response codes to messages; entries have the
    # form {code: (shortmessage, longmessage)}.
    # See http://www.w3.org/hypertext/WWW/Protocols/HTTP/HTRESP.html
    responses = {
        200: ('OK', 'Request fulfilled, document follows'),
        201: ('Created', 'Document created, URL follows'),
        202: ('Accepted',
              'Request accepted, processing continues off-line'),
        203: ('Partial information', 'Request fulfilled from cache'),
        204: ('No response', 'Request fulfilled, nothing follows'),

        301: ('Moved', 'Object moved permanently -- see URI list'),
        302: ('Found', 'Object moved temporarily -- see URI list'),
        303: ('Method', 'Object moved -- see Method and URL list'),
        304: ('Not modified',
              'Document has not changed singe given time'),

        400: ('Bad request',
              'Bad request syntax or unsupported method'),
        401: ('Unauthorized',
              'No permission -- see authorization schemes'),
        402: ('Payment required',
              'No payment -- see charging schemes'),
        403: ('Forbidden',
              'Request forbidden -- authorization will not help'),
        404: ('Not found', 'Nothing matches the given URI'),

        500: ('Internal error', 'Server got itself in trouble'),
        501: ('Not implemented',
              'Server does not support this operation'),
        502: ('Service temporarily overloaded',
              'The server cannot process the request due to a high load'),
        503: ('Gateway timeout',
              'The gateway server did not receive a timely response'),

        }

    responses_win = {
        200: ('OK', 'Request fulfilled, document follows'),
        201: ('Created', 'Document created, URL follows'),
        202: ('Accepted',
              'Request accepted, processing continues off-line'),
        203: ('Partial information', 'Request fulfilled from cache'),
        204: ('No response', 'Request fulfilled, nothing follows'),

        301: ('Moved', 'Object moved permanently -- see URI list'),
        302: ('Found', 'Object moved temporarily -- see URI list'),
        303: ('Method', 'Object moved -- see Method and URL list'),
        304: ('Not modified',
              'Document has not changed singe given time'),

        400: ('Bad request',
              'Bad request syntax or unsupported method'),
        401: ('Unauthorized',
              'No permission -- see authorization schemes'),
        402: ('Payment required',
              'No payment -- see charging schemes'),
        403: ('Forbidden',
              'Request forbidden -- authorization will not help'),
        404: ('Object Not found', 'Nothing matches the given URI'),

        500: ('Internal error', 'Server got itself in trouble'),
        501: ('Not implemented',
              'Server does not support this operation'),
        502: ('Service temporarily overloaded',
              'The server cannot process the request due to a high load'),
        503: ('Gateway timeout',
              'The gateway server did not receive a timely response'),

        }

