#!/usr/bin/python
"""This is the main config file for HoneyWeb be very careful when editing
"""

"""Persistence: Persistence returns the same server version to the same host for a certain period of time
   persist = 0 (No persistance of headers)
   persist = 1 (maintain memory and return the same headers from initial connection)
   persist_time is the time in seconds that persistance is maintained.
   persist_time = 7200 (default, 0 is for as long as the app is running)
"""
persist = 1 
persist_time = 7200

"""Bogus request 404 codes. This is to purposely send 404's in case someone is testing us to see if we are a real server
   Setting to 1 turns on Bogus request monitoring 0 turns it off. Certain key words are searched such as test and foo.
   Bogus checks should only be used with persistence!!!!!!! 
   The first set will more closely match Apache Characteristics while the second will more closely match
   IIS
""" 
Bog_Req = 1
Bog_Words = ['test', 'nessus', 'foo', 'stuff', 'whisker', 'looking', '%2f'] 
#Bog_Words = ['test', 'nessus', 'foo', 'stuff', 'whisker', 'looking'] 

"""Default_Server: This value can be random_win, random_unix, random_all or a specific version
"""
Default_Server = 'random_any'

"""Server Family classes and server definitions. If you want to add more just add another server and give it a unique number
"""

u_serv = {}
w_serv = {}

u_serv['unix_1'] = 'Apache/1.3.12 (Unix)  (Red Hat/Linux) mod_ssl/2.6.6 OpenSSL/0.9.5a PHP/4.0.4pl1 mod_perl/1.24'
u_serv['unix_2'] = 'Apache/1.3.22 (Unix)  (Red Hat/Linux) mod_ssl/2.6.6 OpenSSL/0.9.5a PHP/4.0.4pl1 mod_perl/1.24'
u_serv['unix_3'] = 'Netscape-Enterprise/3.6 SP3'
u_serv['unix_4'] = 'Netscape-Enterprise/6.0'
u_serv['unix_5'] = 'Apache-AdvancedExtranetServer/1.3.23 (Mandrake Linux/4.2mdk) mod_ssl/2.8.7 OpenSSL/0.9.6c PHP/4.1.2'
u_serv['unix_6'] = 'Apache/2.0.40 (Red Hat Linux)'
u_serv['unix_7'] = 'Apache/1.3.26 (Unix) mod_ssl/2.8.10 OpenSSL/0.9.6'
u_serv['unix_8'] = 'Apache/1.3.27 (Unix) mod_perl/1.27'
u_serv['unix_9'] = 'Netscape-Enterprise/4.1'
u_serv['unix_10'] = 'Apache/1.3.20 Sun Cobalt (Unix) mod_ssl/2.8.4 OpenSSL/0.9.6b PHP/4.0.6 mod_auth_pam_external/0.1 FrontPage/4.0.4.3 mod_perl/1.25'
u_serv['unix_11'] = 'Apache'
w_serv['win_1'] = 'Microsoft-IIS/5.0'
w_serv['win_2'] = 'Microsoft-IIS/4.0'
w_serv['win_3'] = 'Microsoft-IIS/3.0'
w_serv['win_4'] = 'Microsoft-IIS/6.0'


"""Extension declarations. If an extension is not declared than it will be handled by a default value
"""

dir = {}
exe = {}
ida = {}
idq = {}
pl = {}
asp = {}
html = {}
shtml = {}
htm = {}
shtm = {}
txt = {}
jsp = {}
php = {}
cfm = {}
dll = {}
mdb = {}
cgi = {}
htr = {}
asa = {}
none = {}

""" THe generic mapping is really a general string match if none of the extension maps are found. Usefull for .htaccess and things like that
"""
generic = {}

"""Extension specific Default versions. Specifc versions can be defined such a demonstrated by htr
"""

exe['request_default'] = ['random_win']
ida['request_default'] = ['random_win']
idq['request_default'] = ['random_win']
pl['request_default'] = ['random_any']
asp['request_default'] = ['random_win']
dll['request_default'] = ['random_win']
dir['request_default'] = ['random_any']
php['request_default'] = ['random_unix']
jsp['request_default'] = ['random_any']
htm['request_default'] = ['random_any']
shtm['request_default'] = ['random_any']
html['request_default'] = ['random_any']
shtml['request_default'] = ['random_any']
cfm['request_default'] = ['random_win']
txt['request_default'] = ['random_any']
cgi['request_default'] = ['random_unix']
htr['request_default'] = ['Microsoft-IIS/5.0']
asa['request_default'] = ['Microsoft-IIS/5.0']
mdb['request_default'] = ['random_win']
none['request_default'] = ['random_unix']


""" Specific request mapping. If there isn't a mapping then the extension default will be used. If there is not an extension default than the 
    default will be used
"""

cfm['admin/application.cfm'] = [w_serv['win_2']]		# Win Bugtraq 1021

"""Dir is anything that does not have a . after the last / so it could be used for dir listing and files with no extension such as passwd
"""

none['/etc/passwd'] = [u_serv['unix_1'],200, 'attack-pages/passwd.txt']   #Unix /etc/passwd
none['/etc/shadow'] = [u_serv['unix_2']]                   #Unix /etc/shadow


dir['REVLOG /'] = [u_serv['unix_3']]                      #Netscape Enterpise DOS bugtraq 2294

exe['cmd.exe'] = [w_serv['win_1'],404]  #Wind Generic cmd.exe
exe['root.exe'] = [w_serv['win_1'],404]                   #Wind Code Red infected host 
exe['nc.exe'] = [w_serv['win_2']]                         #Wind Generic NetCat access
exe['/_vti_bin/shtml.exe'] = [w_serv['win_2']]            #Wind Bugtraq ID 1174 


asa['global.asa'] = [w_serv['win_3'],404]            	# Will make server appear as apache 
#asa['global.asa'] = [w_serv['win_3'],500]            	# Will make server appear as Windows 

php['/modules/check_me.php'] = [u_serv['unix_1']]         #Squirrel Mail spellcheck arbitrary command
php['left_main.php'] = [u_serv['unix_1']]                 #Squirrel Mail theme
php['bb_smilies.php'] = [u_serv['unix_1']]                #PHP-Nuke Vuln

dll['fp30reg.dll'] = [w_serv['win_1']]                    # Win bugtraq 2906
dll['fp4areg.dll'] = [w_serv['win_1']]                   # Win bugtraq 2906
dll['/_vti_bin/shtml.dll'] = [w_serv['win_2']]
dll['/dvwssr.dll'] = [w_serv['win_2']]                    # Win bugtraq 1108

""" More Extension map. Extensions must be in here as well. This is because these are really just Python dictionaries instead of a true config    file
"""


extensions ={}
extensions['ida']=ida
extensions['idq']=idq
extensions['pl']=pl
extensions['asp']=asp
extensions['exe']=exe
extensions['dir']=dir
extensions['html']=html
extensions['shtml']=shtml
extensions['shtm']=shtm
extensions['htm']=htm
extensions['php']=php
extensions['cfm']=cfm
extensions['dll']=dll
extensions['mdb']=mdb
extensions['txt']=txt
extensions['cgi']=cgi
extensions['htr']=htr
extensions['jsp']=jsp
extensions['asa']=asa
extensions['none']=none

""" These are for generic matches. Do not add them to extension map
"""
generic['.htaccess'] = [u_serv['unix_1'],200,'attack-pages/htaccess.txt']   #Apache htaccess attempt
generic['.htpasswd'] = [u_serv['unix_1'],200,'attack-pages/htpasswd.txt']   #Apache htgroup attempt
generic['_vti_rpc'] = [w_serv['win_2']]                    #FrontPage _vti_rpc bugtraq 2144
generic['~nobody'] = [u_serv['unix_1'],200,'attack-pages/apache-dir.html']    #Apache stuff
generic['~root'] = [u_serv['unix_1'],200, 'attack-pages/apache-dir.html']     # Apache stuff 
generic['.hash'] = [u_serv['unix_1']]                    #I saw someone post about this in their logs 


